// _gen/core/value.asdl.cc is generated by asdl_main.py

#include "_gen/core/value.asdl.h"
#include <assert.h>
#include "prebuilt/asdl/runtime.mycpp.h"  // generated code uses wrappers here
#include "_gen/frontend/syntax.asdl.h"  // "use" in ASDL 
#include "_gen/core/runtime.asdl.h"  // "use" in ASDL 

// Generated code uses these types
using hnode_asdl::hnode;
using hnode_asdl::Field;
using hnode_asdl::color_e;


namespace value_asdl {


hnode_t* IntBox::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(StrFromC("IntBox"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(str(this->i), color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("i"), x0));

  return out_node;
}


hnode_t* ProcDefaults::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(StrFromC("ProcDefaults"));
  List<Field*>* L = out_node->fields;

  if (this->for_word != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<value_t*> it(this->for_word); !it.Done(); it.Next()) {
      value_t* i0 = it.Value();
      hnode_t* h = (i0 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i0->PrettyTree(seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("for_word"), x0));
  }

  if (this->for_typed != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<value_t*> it(this->for_typed); !it.Done(); it.Next()) {
      value_t* i1 = it.Value();
      hnode_t* h = (i1 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i1->PrettyTree(seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("for_typed"), x1));
  }

  if (this->for_named) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x2 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<BigStr*, value_t*> it(this->for_named); !it.Done();
         it.Next()) {
      auto k2 = it.Key();
      auto v2 = it.Value();
      x2->children->append(runtime::NewLeaf(k2, color_e::StringConst));
      x2->children->append(v2->PrettyTree(seen));
    }
    L->append(Alloc<Field>(StrFromC ("for_named"), x2));
  }

  if (this->for_block) {  // Optional
    hnode_t* x3 = this->for_block->PrettyTree(seen);
    L->append(Alloc<Field>(StrFromC("for_block"), x3));
  }

  return out_node;
}


hnode_t* LeftName::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(StrFromC("LeftName"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = runtime::NewLeaf(this->name, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  hnode_t* x1 = this->blame_loc->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("blame_loc"), x1));

  return out_node;
}

BigStr* y_lvalue_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case y_lvalue_e::Local:
    v = "Local"; break;
  case y_lvalue_e::Container:
    v = "Container"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "y_lvalue.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* y_lvalue__Container::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(y_lvalue_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->obj->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("obj"), x0));

  hnode_t* x1 = this->index->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("index"), x1));

  return out_node;
}


hnode_t* y_lvalue_t::PrettyTree(Dict<int, bool>* seen) {
  switch (this->tag()) {
  case y_lvalue_e::Local: {
    LeftName* obj = static_cast<LeftName*>(this);
    return obj->PrettyTree(seen);
  }
  case y_lvalue_e::Container: {
    y_lvalue__Container* obj = static_cast<y_lvalue__Container*>(this);
    return obj->PrettyTree(seen);
  }
  default:
    assert(0);
  }
}
BigStr* sh_lvalue_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case sh_lvalue_e::Var:
    v = "Var"; break;
  case sh_lvalue_e::Indexed:
    v = "Indexed"; break;
  case sh_lvalue_e::Keyed:
    v = "Keyed"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "sh_lvalue.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* sh_lvalue__Indexed::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(sh_lvalue_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = runtime::NewLeaf(this->name, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  hnode_t* x1 = Alloc<hnode::Leaf>(str(this->index), color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("index"), x1));

  hnode_t* x2 = this->blame_loc->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("blame_loc"), x2));

  return out_node;
}


hnode_t* sh_lvalue__Keyed::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(sh_lvalue_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = runtime::NewLeaf(this->name, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  hnode_t* x1 = runtime::NewLeaf(this->key, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("key"), x1));

  hnode_t* x2 = this->blame_loc->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("blame_loc"), x2));

  return out_node;
}


hnode_t* sh_lvalue_t::PrettyTree(Dict<int, bool>* seen) {
  switch (this->tag()) {
  case sh_lvalue_e::Var: {
    LeftName* obj = static_cast<LeftName*>(this);
    return obj->PrettyTree(seen);
  }
  case sh_lvalue_e::Indexed: {
    sh_lvalue__Indexed* obj = static_cast<sh_lvalue__Indexed*>(this);
    return obj->PrettyTree(seen);
  }
  case sh_lvalue_e::Keyed: {
    sh_lvalue__Keyed* obj = static_cast<sh_lvalue__Keyed*>(this);
    return obj->PrettyTree(seen);
  }
  default:
    assert(0);
  }
}
BigStr* eggex_ops_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case eggex_ops_e::No:
    v = "No"; break;
  case eggex_ops_e::Yes:
    v = "Yes"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "eggex_ops.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

eggex_ops__No* eggex_ops::No = &geggex_ops__No.obj;

GcGlobal<eggex_ops__No> geggex_ops__No = 
  { ObjHeader::Global(eggex_ops_e::No) };

hnode_t* eggex_ops__No::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(eggex_ops_str(this->tag()));
  return out_node;
}


hnode_t* eggex_ops__Yes::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(eggex_ops_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->convert_funcs != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<value_t*> it(this->convert_funcs); !it.Done(); it.Next()) {
      value_t* i0 = it.Value();
      hnode_t* h = (i0 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i0->PrettyTree(seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("convert_funcs"), x0));
  }

  if (this->convert_toks != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<syntax_asdl::Token*> it(this->convert_toks); !it.Done();
         it.Next()) {
      syntax_asdl::Token* i1 = it.Value();
      hnode_t* h = (i1 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i1->PrettyTree(seen);
      x1->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("convert_toks"), x1));
  }

  if (this->capture_names != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<BigStr*> it(this->capture_names); !it.Done(); it.Next()) {
      BigStr* i2 = it.Value();
      x2->children->append(runtime::NewLeaf(i2, color_e::StringConst));
    }
    L->append(Alloc<Field>(StrFromC("capture_names"), x2));
  }

  return out_node;
}


hnode_t* eggex_ops_t::PrettyTree(Dict<int, bool>* seen) {
  switch (this->tag()) {
  case eggex_ops_e::No: {
    eggex_ops__No* obj = static_cast<eggex_ops__No*>(this);
    return obj->PrettyTree(seen);
  }
  case eggex_ops_e::Yes: {
    eggex_ops__Yes* obj = static_cast<eggex_ops__Yes*>(this);
    return obj->PrettyTree(seen);
  }
  default:
    assert(0);
  }
}

hnode_t* RegexMatch::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(StrFromC("RegexMatch"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = runtime::NewLeaf(this->s, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("s"), x0));

  if (this->indices != nullptr) {  // List
    hnode::Array* x1 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<int> it(this->indices); !it.Done(); it.Next()) {
      int i1 = it.Value();
      x1->children->append(Alloc<hnode::Leaf>(str(i1), color_e::OtherConst));
    }
    L->append(Alloc<Field>(StrFromC("indices"), x1));
  }

  hnode_t* x2 = this->ops->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("ops"), x2));

  return out_node;
}

BigStr* regex_match_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case regex_match_e::No:
    v = "No"; break;
  case regex_match_e::Yes:
    v = "Yes"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "regex_match.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

regex_match__No* regex_match::No = &gregex_match__No.obj;

GcGlobal<regex_match__No> gregex_match__No = 
  { ObjHeader::Global(regex_match_e::No) };

hnode_t* regex_match__No::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(regex_match_str(this->tag()));
  return out_node;
}


hnode_t* regex_match_t::PrettyTree(Dict<int, bool>* seen) {
  switch (this->tag()) {
  case regex_match_e::No: {
    regex_match__No* obj = static_cast<regex_match__No*>(this);
    return obj->PrettyTree(seen);
  }
  case regex_match_e::Yes: {
    RegexMatch* obj = static_cast<RegexMatch*>(this);
    return obj->PrettyTree(seen);
  }
  default:
    assert(0);
  }
}
BigStr* value_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case value_e::Interrupted:
    v = "Interrupted"; break;
  case value_e::Stdin:
    v = "Stdin"; break;
  case value_e::Undef:
    v = "Undef"; break;
  case value_e::Str:
    v = "Str"; break;
  case value_e::BashArray:
    v = "BashArray"; break;
  case value_e::SparseArray:
    v = "SparseArray"; break;
  case value_e::BashAssoc:
    v = "BashAssoc"; break;
  case value_e::Null:
    v = "Null"; break;
  case value_e::Bool:
    v = "Bool"; break;
  case value_e::Int:
    v = "Int"; break;
  case value_e::Float:
    v = "Float"; break;
  case value_e::List:
    v = "List"; break;
  case value_e::Dict:
    v = "Dict"; break;
  case value_e::Eggex:
    v = "Eggex"; break;
  case value_e::Match:
    v = "Match"; break;
  case value_e::Expr:
    v = "Expr"; break;
  case value_e::Command:
    v = "Command"; break;
  case value_e::Block:
    v = "Block"; break;
  case value_e::Place:
    v = "Place"; break;
  case value_e::Module:
    v = "Module"; break;
  case value_e::IO:
    v = "IO"; break;
  case value_e::Guts:
    v = "Guts"; break;
  case value_e::BuiltinFunc:
    v = "BuiltinFunc"; break;
  case value_e::BoundFunc:
    v = "BoundFunc"; break;
  case value_e::Proc:
    v = "Proc"; break;
  case value_e::Func:
    v = "Func"; break;
  case value_e::Slice:
    v = "Slice"; break;
  case value_e::Range:
    v = "Range"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "value.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

value__Interrupted* value::Interrupted = &gvalue__Interrupted.obj;

GcGlobal<value__Interrupted> gvalue__Interrupted = 
  { ObjHeader::Global(value_e::Interrupted) };

value__Stdin* value::Stdin = &gvalue__Stdin.obj;

GcGlobal<value__Stdin> gvalue__Stdin = 
  { ObjHeader::Global(value_e::Stdin) };

value__Undef* value::Undef = &gvalue__Undef.obj;

GcGlobal<value__Undef> gvalue__Undef = 
  { ObjHeader::Global(value_e::Undef) };

value__Null* value::Null = &gvalue__Null.obj;

GcGlobal<value__Null> gvalue__Null = 
  { ObjHeader::Global(value_e::Null) };

hnode_t* value__Interrupted::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  return out_node;
}


hnode_t* value__Stdin::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  return out_node;
}


hnode_t* value__Undef::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  return out_node;
}


hnode_t* value__Str::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = runtime::NewLeaf(this->s, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("s"), x0));

  return out_node;
}


hnode_t* value__BashArray::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->strs != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<BigStr*> it(this->strs); !it.Done(); it.Next()) {
      BigStr* i0 = it.Value();
      x0->children->append(runtime::NewLeaf(i0, color_e::StringConst));
    }
    L->append(Alloc<Field>(StrFromC("strs"), x0));
  }

  return out_node;
}


hnode_t* value__SparseArray::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->d) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x0 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<mops::BigInt, BigStr*> it(this->d); !it.Done(); it.Next()) {
      auto k0 = it.Key();
      auto v0 = it.Value();
      x0->children->append(Alloc<hnode::Leaf>(mops::ToStr(k0),
                           color_e::OtherConst));
      x0->children->append(runtime::NewLeaf(v0, color_e::StringConst));
    }
    L->append(Alloc<Field>(StrFromC ("d"), x0));
  }

  hnode_t* x1 = Alloc<hnode::Leaf>(mops::ToStr(this->max_index),
                                   color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("max_index"), x1));

  return out_node;
}


hnode_t* value__BashAssoc::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->d) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x0 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<BigStr*, BigStr*> it(this->d); !it.Done(); it.Next()) {
      auto k0 = it.Key();
      auto v0 = it.Value();
      x0->children->append(runtime::NewLeaf(k0, color_e::StringConst));
      x0->children->append(runtime::NewLeaf(v0, color_e::StringConst));
    }
    L->append(Alloc<Field>(StrFromC ("d"), x0));
  }

  return out_node;
}


hnode_t* value__Null::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  return out_node;
}


hnode_t* value__Bool::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(this->b ? runtime::TRUE_STR :
                                   runtime::FALSE_STR, color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("b"), x0));

  return out_node;
}


hnode_t* value__Int::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(mops::ToStr(this->i), color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("i"), x0));

  return out_node;
}


hnode_t* value__Float::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(str(this->f), color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("f"), x0));

  return out_node;
}


hnode_t* value__List::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->items != nullptr) {  // List
    hnode::Array* x0 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<value_t*> it(this->items); !it.Done(); it.Next()) {
      value_t* i0 = it.Value();
      hnode_t* h = (i0 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i0->PrettyTree(seen);
      x0->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("items"), x0));
  }

  return out_node;
}


hnode_t* value__Dict::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->d) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x0 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<BigStr*, value_t*> it(this->d); !it.Done(); it.Next()) {
      auto k0 = it.Key();
      auto v0 = it.Value();
      x0->children->append(runtime::NewLeaf(k0, color_e::StringConst));
      x0->children->append(v0->PrettyTree(seen));
    }
    L->append(Alloc<Field>(StrFromC ("d"), x0));
  }

  return out_node;
}


hnode_t* value__Eggex::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->spliced->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("spliced"), x0));

  hnode_t* x1 = runtime::NewLeaf(this->canonical_flags, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("canonical_flags"), x1));

  if (this->convert_funcs != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<value_t*> it(this->convert_funcs); !it.Done(); it.Next()) {
      value_t* i2 = it.Value();
      hnode_t* h = (i2 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i2->PrettyTree(seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("convert_funcs"), x2));
  }

  if (this->convert_toks != nullptr) {  // List
    hnode::Array* x3 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<syntax_asdl::Token*> it(this->convert_toks); !it.Done();
         it.Next()) {
      syntax_asdl::Token* i3 = it.Value();
      hnode_t* h = (i3 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i3->PrettyTree(seen);
      x3->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("convert_toks"), x3));
  }

  if (this->as_ere) {  // Optional
    hnode_t* x4 = runtime::NewLeaf(this->as_ere, color_e::StringConst);
    L->append(Alloc<Field>(StrFromC("as_ere"), x4));
  }

  if (this->capture_names != nullptr) {  // List
    hnode::Array* x5 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<BigStr*> it(this->capture_names); !it.Done(); it.Next()) {
      BigStr* i5 = it.Value();
      x5->children->append(runtime::NewLeaf(i5, color_e::StringConst));
    }
    L->append(Alloc<Field>(StrFromC("capture_names"), x5));
  }

  return out_node;
}


hnode_t* value__Expr::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->e->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("e"), x0));

  return out_node;
}


hnode_t* value__Command::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->c->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("c"), x0));

  return out_node;
}


hnode_t* value__Block::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->block->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("block"), x0));

  return out_node;
}


hnode_t* value__Place::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->lval->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("lval"), x0));

  if (this->frame) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x1 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<BigStr*, runtime_asdl::Cell*> it(this->frame); !it.Done();
         it.Next()) {
      auto k1 = it.Key();
      auto v1 = it.Value();
      x1->children->append(runtime::NewLeaf(k1, color_e::StringConst));
      x1->children->append(v1->PrettyTree(seen));
    }
    L->append(Alloc<Field>(StrFromC ("frame"), x1));
  }

  return out_node;
}


hnode_t* value__Module::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->defs) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x0 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<BigStr*, value_t*> it(this->defs); !it.Done(); it.Next()) {
      auto k0 = it.Key();
      auto v0 = it.Value();
      x0->children->append(runtime::NewLeaf(k0, color_e::StringConst));
      x0->children->append(v0->PrettyTree(seen));
    }
    L->append(Alloc<Field>(StrFromC ("defs"), x0));
  }

  return out_node;
}


hnode_t* value__IO::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::External>(this->cmd_ev);
  L->append(Alloc<Field>(StrFromC("cmd_ev"), x0));

  hnode_t* x1 = Alloc<hnode::External>(this->prompt_ev);
  L->append(Alloc<Field>(StrFromC("prompt_ev"), x1));

  return out_node;
}


hnode_t* value__Guts::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::External>(this->vm);
  L->append(Alloc<Field>(StrFromC("vm"), x0));

  return out_node;
}


hnode_t* value__BuiltinFunc::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::External>(this->callable);
  L->append(Alloc<Field>(StrFromC("callable"), x0));

  return out_node;
}


hnode_t* value__BoundFunc::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->me->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("me"), x0));

  hnode_t* x1 = this->func->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("func"), x1));

  return out_node;
}


hnode_t* value__Proc::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = runtime::NewLeaf(this->name, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  hnode_t* x1 = this->name_tok->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("name_tok"), x1));

  hnode_t* x2 = this->sig->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("sig"), x2));

  hnode_t* x3 = this->body->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("body"), x3));

  if (this->defaults) {  // Optional
    hnode_t* x4 = this->defaults->PrettyTree(seen);
    L->append(Alloc<Field>(StrFromC("defaults"), x4));
  }

  hnode_t* x5 = Alloc<hnode::Leaf>(this->sh_compat ? runtime::TRUE_STR :
                                   runtime::FALSE_STR, color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("sh_compat"), x5));

  return out_node;
}


hnode_t* value__Func::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = runtime::NewLeaf(this->name, color_e::StringConst);
  L->append(Alloc<Field>(StrFromC("name"), x0));

  hnode_t* x1 = this->parsed->PrettyTree(seen);
  L->append(Alloc<Field>(StrFromC("parsed"), x1));

  if (this->pos_defaults != nullptr) {  // List
    hnode::Array* x2 = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
    for (ListIter<value_t*> it(this->pos_defaults); !it.Done(); it.Next()) {
      value_t* i2 = it.Value();
      hnode_t* h = (i2 == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                    color_e::OtherConst) : i2->PrettyTree(seen);
      x2->children->append(h);
    }
    L->append(Alloc<Field>(StrFromC("pos_defaults"), x2));
  }

  if (this->named_defaults) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x3 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<BigStr*, value_t*> it(this->named_defaults); !it.Done();
         it.Next()) {
      auto k3 = it.Key();
      auto v3 = it.Value();
      x3->children->append(runtime::NewLeaf(k3, color_e::StringConst));
      x3->children->append(v3->PrettyTree(seen));
    }
    L->append(Alloc<Field>(StrFromC ("named_defaults"), x3));
  }

  if (this->module_) {  // Dict
    auto m = Alloc<hnode::Leaf>(StrFromC("Dict"), color_e::OtherConst);
    hnode::Array* x4 = Alloc<hnode::Array>(NewList<hnode_t*>({m}));
    for (DictIter<BigStr*, runtime_asdl::Cell*> it(this->module_); !it.Done();
         it.Next()) {
      auto k4 = it.Key();
      auto v4 = it.Value();
      x4->children->append(runtime::NewLeaf(k4, color_e::StringConst));
      x4->children->append(v4->PrettyTree(seen));
    }
    L->append(Alloc<Field>(StrFromC ("module_"), x4));
  }

  return out_node;
}


hnode_t* value__Slice::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  if (this->lower) {  // Optional
    hnode_t* x0 = this->lower->PrettyTree(seen);
    L->append(Alloc<Field>(StrFromC("lower"), x0));
  }

  if (this->upper) {  // Optional
    hnode_t* x1 = this->upper->PrettyTree(seen);
    L->append(Alloc<Field>(StrFromC("upper"), x1));
  }

  return out_node;
}


hnode_t* value__Range::PrettyTree(Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);
  hnode::Record* out_node = runtime::NewRecord(value_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = Alloc<hnode::Leaf>(str(this->lower), color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("lower"), x0));

  hnode_t* x1 = Alloc<hnode::Leaf>(str(this->upper), color_e::OtherConst);
  L->append(Alloc<Field>(StrFromC("upper"), x1));

  return out_node;
}


hnode_t* value_t::PrettyTree(Dict<int, bool>* seen) {
  switch (this->tag()) {
  case value_e::Interrupted: {
    value__Interrupted* obj = static_cast<value__Interrupted*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Stdin: {
    value__Stdin* obj = static_cast<value__Stdin*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Undef: {
    value__Undef* obj = static_cast<value__Undef*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Str: {
    value__Str* obj = static_cast<value__Str*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::BashArray: {
    value__BashArray* obj = static_cast<value__BashArray*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::SparseArray: {
    value__SparseArray* obj = static_cast<value__SparseArray*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::BashAssoc: {
    value__BashAssoc* obj = static_cast<value__BashAssoc*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Null: {
    value__Null* obj = static_cast<value__Null*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Bool: {
    value__Bool* obj = static_cast<value__Bool*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Int: {
    value__Int* obj = static_cast<value__Int*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Float: {
    value__Float* obj = static_cast<value__Float*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::List: {
    value__List* obj = static_cast<value__List*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Dict: {
    value__Dict* obj = static_cast<value__Dict*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Eggex: {
    value__Eggex* obj = static_cast<value__Eggex*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Match: {
    RegexMatch* obj = static_cast<RegexMatch*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Expr: {
    value__Expr* obj = static_cast<value__Expr*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Command: {
    value__Command* obj = static_cast<value__Command*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Block: {
    value__Block* obj = static_cast<value__Block*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Place: {
    value__Place* obj = static_cast<value__Place*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Module: {
    value__Module* obj = static_cast<value__Module*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::IO: {
    value__IO* obj = static_cast<value__IO*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Guts: {
    value__Guts* obj = static_cast<value__Guts*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::BuiltinFunc: {
    value__BuiltinFunc* obj = static_cast<value__BuiltinFunc*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::BoundFunc: {
    value__BoundFunc* obj = static_cast<value__BoundFunc*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Proc: {
    value__Proc* obj = static_cast<value__Proc*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Func: {
    value__Func* obj = static_cast<value__Func*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Slice: {
    value__Slice* obj = static_cast<value__Slice*>(this);
    return obj->PrettyTree(seen);
  }
  case value_e::Range: {
    value__Range* obj = static_cast<value__Range*>(this);
    return obj->PrettyTree(seen);
  }
  default:
    assert(0);
  }
}

}  // namespace value_asdl
